<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'country_id', 'birth_date', 'email', 'phone_number', 'gender');

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function familyRelations()
    {
        return $this->belongsTo('App\Models\MemberRelation');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

}